//###################################################################################################################################################################################
//
// Headerdatei der Bibliothek "fm25cl64b.h"
//
// Ersteller : K. Evangelos 
// Datum     : Juni 2018
// Umgebung  : Code Composer Studio 6.20
//
// Erlutert : * Inhalt: - FM25CL64B BEFEHLSSATZ
//                       - Prototypen
//
//             * Diese Library ermglicht die Mode 1 und Mode 2 <Messung fr ein Stop-Signal durchzufhren. Die Bereiche die mit TO_DO markiert sind muss der Anwender spter auf
//               seinen Mikrocontroller anpassen. Es werden sicherlich die SPI-Funktionen und Defines die Calibration Period  und die Clock Period sein.
//
//                                     ------------------
//                                    |                  |        ------------
//                                    |       !CS GPIO23 |------>| CS         |
//                                    |      MOSI GPIO16 |------>| MOSI       |
//                                    |      MISO GPIO17 |<------| MISO       |
//                                    |       SCK GPIO18 |------>| SCK        |
//                                    |                  |       |            |
//									  |!STE (Als Trigger)|       |            |
//                                    |                  |       |            |
//                                    |            VCC   |<----->| VCC        |
//                                    |      1 MHz GND   |<----->| GND        |
//                                     ------------------         ------------
//                                      (TMS320F28377d)            (FM25CL64B)
//################################################################################################################################################################################

#ifndef FM25CL64B_H
#define FM25CL64B_H

#include "F28x_Project.h"
#include "myCentral.h"
#include "mySPI.h"

#ifdef SMU_COM_FM25CL64b

//########################### SPI PIN DEFINES #####################################################################################################################################

#define FM25CL64B_SPI_CS_LOW      GpioDataRegs.GPACLEAR.bit.GPIO23 = 1           // Ausgnge verwalten
#define FM25CL64B_SPI_CS_HIGH     GpioDataRegs.GPASET.bit.GPIO23 = 1             // Ausgnge verwalten

//########################### OPCODE COMMANDS #####################################################################################################################################
//
// --- Kurz Info ------------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Schreiben allgemein (vgl. Datenblatt, Seite 6)
// Bevor man dem FM25CL64B beschreiben kann, muss diesem die Aktion signalisiert werden. Dazu sollte zuerst der Befehl WREN gesendet werden (vgl. Datenblat, Seite 6). Hierbei wird 
// beim IC eine Flag gesetzt, die das Schreiben ermglicht. Alle Schreibbefehle werden ignoriert fals WREN nicht zuerst gesendet wurde. Dies muss vor JEDEM Schreibbefehl gemacht 
// werden, da die Flag automatisch - nachdem CS wieder auf High geht - wieder gelscht wird.
//
// Lesen allgemein (vgl. Datenblatt, Seite 6)
// Das Schreiben kann man wieder deaktivieren indem der WRDI-Befehl gesendet wird. Am sonsten wird dieser automatisch deaktiviert, wenn die CS-Leitung auf High-Pegel geht.
//
// Status Register (vgl. Datenblatt, Seite 7)
// Fr das Status-Register sind die Befehle WRSR und RDSR zustndig (Schreiben und Lesen). Beim Schreiben muss zuerst WREN gesetzt werden, dann folgt der WRSR-Befehl und absch-
// lieend die Information die geschrieben werden soll. Beim Lesen sollte das WREN nicht gesetzt sein. Zuerst wird der RDSR-Befehl gesendet. Daraufhin antwortet der IC.

// Status Register-Inhalt
// Bit 7   |   Bit6   |   Bit 5   |   Bit 4   |   Bit 3   |   Bit 2   |   Bit 1   |   Bit 0
// ------------------------------------------------------------------------------------------
// WPEN    |   X      |   X       |   X       |   BP1     |   BP0     |   WEL     |   X
//
// Bit 0: Don't care. Nicht beschreibbar, liefert immer 0 zurck
// Bit 1: Auch als WEL bezeichnet. Zeigt an ob der IC beschreibbar ist oder nicht.
//        WEL = '0' => Schreiben deaktiviert
//        WEL = '1' => Schreiben aktiviert
// Bit 2: Auch als BP0 bezeichnet. Kann Blcke Schutze (vgl. Tabelle 4). Nehme fr mich BP0 = 0, BP1 = 0.
// Bit 3: Auch als BP1 bezeichnet. Kann Blcke Schutze (vgl. Tabelle 4). Nehme fr mich BP0 = 0, BP1 = 0.
// Bit 4: Don't care. Nicht beschreibbar, liefert immer 0 zurck
// Bit 5: Don't care. Nicht beschreibbar, liefert immer 0 zurck
// Bit 6: Don't care. Nicht beschreibbar, liefert immer 0 zurck
// Bit 7: Auch als WPEN bezeichnet. Zusammen mit dem PIN !WP zu betrachten. Habe !WP dauerhaft auf High. Setze WPEN auch auf Low. Status-Register "unprotected", vgl. Tabelle 5
//
// --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#define FM25CL64B_WREN             0x06                                          // Set Write Enable Latch
#define FM25CL64B_WRDI             0x04                                          // Write Disable

#define FM25CL64B_WRSR             0x01                                          // Write Status Register
#define FM25CL64B_RDSR             0x05                                          // Read Status Register

#define FM25CL64B_WRITE            0x02                                          // Write Memory Data
#define FM25CL64B_READ             0x03                                          // Read Memory Data

#define FM25CL64B_DUMMY_VALUE      0xFF                                          // Dummy Wert zum Lesen via SPI (zum Lesen von Daten muss der Master die Clock aktiv halten)

//############################ MEMORY PAGE #######################################################################################################################################
//
// Die Memory-Adressen, werden nicht wirklich bentigt. Habe mir wilkrlich 4 Adressbereiche ausgedacht. Achte nur, dass der Wert 0x1FFF nicht berschrieten wird, da sonst der
// IC wieder von 0 beginnt.

#define FM25CL64B_MEMORY_MAX            0x1FFF                                   // Der FM25CL64B ist ein 8x8kb Speicher, daher nimmt er den Maximalwert von 0x1FFF (oder 8191)
#define FM25CL64B_MEMORY_PAGE_SIZE      0x0800                                   // Spalte den Speicher willkrlich in 4 Bereiche mit 0x0800 (oder 2048) Lnge

#define FM25CL64B_MEMORY_PAGE_1         0x0000                                   // Erster Bereich. Startadresse die 0; Reserviert fr MCU-Daten
#define FM25CL64B_MEMORY_PAGE_2         0x07FF                                   // Zweiter Bereich. Startadresse die 2047; Reserviert fr VS-Daten
#define FM25CL64B_MEMORY_PAGE_3         0x0FFE                                   // Driter Bereich. Startadresse die 4094; Reserviert fr Anwender
#define FM25CL64B_MEMORY_PAGE_4         0x17FD                                   // Vierter Bereich. Startadresse die 6141; Frei

#endif

//############################ PROTOTYPES ########################################################################################################################################

#ifdef SMU_COM_FM25CL64b

void FM25CL64B_SPI_Init(void);                                                    // Initialisiert die SPI Funktion                                               
void FM25CL64B_SPI_Write(unsigned char data);                                     // Ein 8-Bit-Sende-Funktion fr SPI
unsigned char FM25CL64B_SPI_Read(void);                                           // Ein 8-Bit-Empfangs-Funktion fr SPI

void FM25CL64B_Enable_Write(void);                                                // Aktivert die Schreibe-Flag. IC ist nun beschreibbar
void FM25CL64B_Disable_Write(void);                                               // Deaktivert die Schreibe-Flag. IC nicht mehr beschreibbar

void FM25CL64B_Write_Memory(unsigned int addres, unsigned char *data, int length);// Schreibt eine oder mehrere Information/en im Datenblock
void FM25CL64B_Read_Memory(unsigned int addres, unsigned char *data, int length); // Liest eine oder mehrere Information/en vom Datenblock
unsigned char FM25CL64B_Read_Memory_2(unsigned int addres);

void FM25CL64B_Write_StatusRegister(unsigned char data);                           // Beschreibt das Status-Register
unsigned char FM25CL64B_Read_StatusRegister(void);                                 // Liest das Status-Register aus

char FM25CL64B_TestIC(void);                                                       // Testet IC ob funktionstchtig. 1: OK, 0: Fehler

#endif

#endif
