#include "fm25cl64b.h"

#ifdef SMU_COM_FM25CL64b

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
// Initialisation vom SPI modul
// Initialisiert das SPI-Modul. Die SPI wird fr eine Frequenz von F_CPU/4 eingestell. Als Master konfiguriert, MSB zuerst, SCK und CS als inactive High.
//
void FM25CL64B_SPI_Init(void)
{
	GPIO_SetupPinMux(23, GPIO_MUX_CPU1, 0);
	GPIO_SetupPinOptions(23, GPIO_OUTPUT, GPIO_PULLUP);
	FM25CL64B_SPI_CS_HIGH;

	spi_fifo_init();
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
// Sendet eine 8 Bit-Information via SPI
// Zum senden von 1-Byte via SPI
//
void FM25CL64B_SPI_Write(unsigned char data)
{
	int tmp = data << 8; // Der TX-Buffer erwartet immer eine 16-Bit Variable. Dabei wird abe nur das erste Byte bertragen
	spi_xmit(tmp);
}



//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
// Liet eine 8 Bit-Information via SPI
// Die Funktion liesst 1-Byte aus dem FM25CL64B aus und speichert das Ergebnis in einer 1-Byte variable. Dazu wird die SPI-Funktion genutzt.
//
unsigned char FM25CL64B_SPI_Read(void)
{
  int tmp = 0;
  unsigned char value = 0;
  
  FM25CL64B_SPI_Write(FM25CL64B_DUMMY_VALUE);

  tmp = spi_read();
  value = tmp << 8;

  return value;
} 

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
void FM25CL64B_Enable_Write(void)
{
  FM25CL64B_SPI_CS_LOW;                                                         // Ziehe CS auf Low, Frame startet
  FM25CL64B_SPI_Write(FM25CL64B_WREN);                                          // Aktiviere Schreibe-Flag WEL-Bit (nur dann kann man Schreiben)
  FM25CL64B_SPI_CS_HIGH;                                                        // Ziehe CS wieder auf High, Frame beendet
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
void FM25CL64B_Disable_Write(void)
{
  FM25CL64B_SPI_CS_LOW;                                                          // Ziehe CS auf Low, Frame startet
  FM25CL64B_SPI_Write(FM25CL64B_WRDI);                                           // Deaktiviere Schreibe-Flag WEL-Bit (nur dann kann mans Schreiben)  
  FM25CL64B_SPI_CS_HIGH;                                                         // Ziehe CS wieder auf High, Frame beendet
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
void FM25CL64B_Write_Memory(unsigned int addres, unsigned char *data, int length)
{
  unsigned int i = 0;
  FM25CL64B_Enable_Write();                                                      // Aktiviere Schreibe-Flag WEL-Bit (nur dann kann man Schreiben)  
  DELAY_US(5);

  FM25CL64B_SPI_CS_LOW;                                                          // Ziehe CS auf Low, Frame startet
  
  FM25CL64B_SPI_Write(FM25CL64B_WRITE);                                          // Schreibebefehl fr Daten-Block ...
  FM25CL64B_SPI_Write(addres >> 8 );                                             // MSB-Byte. Adresse fr Datensatz.  Nur den Startpunkt whlen (siehe spter warum) ...
  FM25CL64B_SPI_Write(addres & 0xFF);                                            // LSB Byte. ...
  for(i = 0; i < length; i++)                                                    // Der FM25LC64B hat einen internen Zhler. Daten knnen (immer 8-Bit) nacheinander gesendet ...
  {                                                                              // werden und der IC ordnet diese nacheinander ein. Daher muss nur die Startadresse eingegeben werden. ...
    FM25CL64B_SPI_Write(data[i]);                                                // Beachte wenn der Datensatz grer 0x1FFF (oder 8191) dann fngt der Zhler wieder von 0 an. ...
    DELAY_US(5);
  } // for                                                                       // Dies besser vermeiden.-
  
  FM25CL64B_SPI_CS_HIGH;                                                         // Ziehe CS wieder auf High, Frame beendet
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
void FM25CL64B_Read_Memory(unsigned int addres, unsigned char *data, int length)
{
  unsigned int i = 0;

  FM25CL64B_Disable_Write();                                                     // Deaktiviere Schreibe-Flag WEL-Bit. Passiert auch automatisch, sodass man sich den Befehl auch sparen kann.
  DELAY_US(5);

  FM25CL64B_SPI_CS_LOW;                                                          // Ziehe CS auf Low, Frame startet
  
  FM25CL64B_SPI_Write(FM25CL64B_READ);                                           // Schreibebefehl fr Daten-Block ...
  FM25CL64B_SPI_Write(addres >> 8 );                                             // MSB-Byte. Adresse fr Datensatz.  Nur den Startpunkt whlen (siehe spter warum) ...
  FM25CL64B_SPI_Write(addres & 0xFF);                                            // LSB Byte. ...
  for(i = 0; i < length; i++)                                                    // Der FM25LC64B hat einen internen Zhler. Daten knnen (immer 8-Bit) nacheinander gelesen ...
  {                                                                              // werden, da der IC diese nacheinander senden kann, solange eine Clock zur Verfgung steht. Daher muss nur ... 
    data[i] = FM25CL64B_SPI_Read() >> 8;                                         // die Startadresse eingegeben werden. Beachte wenn der Datensatz grer 0x1FFF (oder 8191) dann fngt der ...
    DELAY_US(5);
  } // for                                                                       // Zhler wieder von 0 an. Dies besser vermeiden.-
  
  FM25CL64B_SPI_CS_HIGH;                                                         // Ziehe CS wieder auf High, Frame beendet
}

unsigned char FM25CL64B_Read_Memory_2(unsigned int addres)
{
  unsigned char data = 0;

  FM25CL64B_SPI_CS_LOW;                                                          // Ziehe CS auf Low, Frame startet

  FM25CL64B_SPI_Write(FM25CL64B_READ);                                           // Schreibebefehl fr Daten-Block ...
  FM25CL64B_SPI_Write(addres >> 8 );                                             // MSB-Byte. Adresse fr Datensatz.  Nur den Startpunkt whlen (siehe spter warum) ...
  FM25CL64B_SPI_Write(addres & 0xFF);                                            // LSB Byte. ...

  data = FM25CL64B_SPI_Read();                                                   // die Startadresse eingegeben werden. Beachte wenn der Datensatz grer 0x1FFF (oder 8191) dann fngt der ...

  FM25CL64B_SPI_CS_HIGH;                                                         // Ziehe CS wieder auf High, Frame beendet

  return data;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
void FM25CL64B_Write_StatusRegister(unsigned char data)
{
  FM25CL64B_Enable_Write();                                                      // Aktiviere Schreibe-Flag WEL-Bit (nur dann kann man Schreiben)  
  DELAY_US(1);

  FM25CL64B_SPI_CS_LOW;                                                          // Ziehe CS auf Low, Frame startet
  
  FM25CL64B_SPI_Write(FM25CL64B_WRSR);                                           // Schreibebefehl fr DStatus-Register ...
  FM25CL64B_SPI_Write(data);                                                     // Sende Information.-

  FM25CL64B_SPI_CS_HIGH;                                                         // Ziehe CS wieder auf High, Frame beendet
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                     
//
unsigned char FM25CL64B_Read_StatusRegister(void)
{
  unsigned char status = 0xFF;                                                   // Lege Variable an um Status-Register zu lesen
  
  FM25CL64B_Disable_Write();                                                     // Deaktiviere Schreibe-Flag WEL-Bit. Passiert auch automatisch, sodass man sich den Befehl auch sparen kann.
  DELAY_US(10);
  
  FM25CL64B_SPI_CS_LOW;                                                          // Ziehe CS auf Low, Frame startet
  
  FM25CL64B_SPI_Write(FM25CL64B_RDSR);                                           // Lesebefehl fr Status-Register ... 
  status = FM25CL64B_SPI_Read();                                                 // Lese Statusregister aus.-
 
  FM25CL64B_SPI_CS_HIGH;                                                         // Ziehe CS wieder auf High, Frame beendet
  
  return status;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//
char FM25CL64B_TestIC(void)
{
  unsigned int sum1 = 0, sum2 = 0;
  int i = 0;
  // Erzeuge Daten
  unsigned char data[256];
  for(i = 0; i < 256; i++)
  {
    data[i] = i + 255;
    sum1 += i;
  } // for
  
  // Sende Info
  FM25CL64B_Write_Memory(0x0000, data, 256);
  
  // Lsche Daten
  for(i = 0; i < 256; i++)
  {
    data[i] = 0;
  } // for
  
  // Empfange Info
  FM25CL64B_Read_Memory(0x0000, data, 256);
  
  // Vergleiche
  for(i = 0; i < 256; i++)
  {
    sum2 += data[i];
  } // for
  
  if(sum1 != sum2) // Null zeigt einen Fehler an
  {
     return 0;
  } // if
  
  return 1;	// Alles OK
}

#endif

